{smcl}
{* *! version 1.0.0 5aug2014}{...}
{title:Title}

{pstd}
{cmd:dsimih table} {hline 2} Create tables of dynamic simulation results after {cmd:svarih}


{marker syntax}{...}
{title:Syntax}

{p 8 15 2}
{cmd:dsimih} {cmdab:t:able} [{it:{help dsimih_table##stat:stat}}] [{help using} {it:filename}] [{cmd:,} {it:{help dsimih_table##options_table:options}}]

{marker stat}{...}
{p2colset 5 16 18 2}{...}
{p2col:{it:stat}}Description{p_end}
{p2line}
{p2col:{cmdab:si:rf}}structural impulse-response function{p_end}
{p2col:{cmdab:sf:evd}}structural forecast-error variance decomposition{p_end}
{p2line}
{p2colreset}{...}

{p 4 6 2}You may specify only one {it:stat}.

{marker options_table}{...}
{synoptset 29 tabbed}{...}
{synopthdr}
{synoptline}
{syntab:Table Data}
{synopt:{opt reg:imes(rgmlist)}}create tables for results of regimes {it:rgmlist}; default: all regimes available in the {cmd:dsimih} results{p_end}
{synopt:{opt i:mpulse(impvars)}}use shock(s) of equation(s) {it:impvars} as impulse variables{p_end}
{synopt:{opt r:esponse(respvars)}}use {it:respvars} as response variable(s){p_end}

{synopt:{opt noci}}suppress confidence intervals{p_end}
{synopt:{opt se}}display standard errors{p_end}
{synopt:{opt set:ypes(selist)}}display standard errors and confidence intervals based on standard errors of type(s) {it:selist}; default: asymptotic{p_end}
{synopt:{opt l:evel(#)}}set confidence level{p_end}
{synopt:{opt st:ep(steplist)}}keep results for forecast horizons in {it:steplist}{p_end}

{syntab:Table Format}
{synopt:{opt byo:rder(irorder)}}display results by {it:irorder}{p_end}
{synopt:{opt f:ormat(%fmt)}}display results in numeric format {it:%fmt}; see {help format}{p_end}
{synopt:{it:{help dsimih_table##list_options:list_options}}}all options allowed by {help list}{p_end}

{syntab:Data Set}
{synopt:{opt n:umber(#)}}access results number {it:#} ; only allowed if the {cmd:using} modifier refers to a {cmd:.ster} file{p_end}
{synopt:{opt k:eep}}keep the Stata data set underlying the results table in memory{p_end}
{synopt:{opt clear}}specifies that it is okay to replace the data in memory, even though the current data have not been saved to disk{p_end}
{synoptline}
{p2colreset}{...}


{marker description}{...}
{title:Description}

{pstd}
{opt dsimih table} creates tables dynamic simulation results created by {help dsimih create}.
Options {opt keep} and {opt clear} allow you to keep the results in Stata data set memory.
If you omit these options, results are only displayed in the results window.


{marker abbreviations}{...}
{title:Abbreviations, definitions, notation, syntax elements}

{pstd}
This help entry uses terminology defined in {help svarih##abbreviations:svarih} and {help dsimih##abbreviations:dsimih}.


{marker options}{...}
{title:Options}

{dlgtab:Table Data}

{phang}
{opt reg:imes(rgmlist)} is a {help numlist} and specifies the volatility regimes for which results are displayed.
By default, results of all regimes that are present in the {cmd:dsimih} results are displayed.
{it:rgmlist} must be a subset of the regimes that occur in the estimation sample.

{phang}
{opt i:mpulse(impvars)} specifies the impulse variables for which the statistics are to be reported.
If {opt impulse()} is not specified, each model variable, in turn, is used.
{it:impvars} may be specified in any way allowed by a standard Stata {help varlist}.
{it:varlist} here does not refer to the variables in memory but to the variables recorded in e(depvar).

{phang}
{opt r:esponse(respvars)} specifies the response variables for which the statistics are to be reported.
If {opt response()} is not specified, each endogenous variable, in turn, is used.
{it:respvars} may be specified in any way allowed by a standard Stata {help varlist}.
{it:varlist} here does not refer to the variables in memory but to the variables recorded in e(depvar).

{phang}
{opt noci} suppresses reporting of the confidence intervals for {it:stat}.

{phang}
{opt se} specifies that standard errors for each statistic also be included in the table.
They are omitted by default.

{phang}
{opt set:ypes(selist)} specifies the standard error types based on which standard error numbers and/or confidence band numbers are included in the table.
{it:selist} may contain individual tokens {opt a:symptotic}, {opt bs} and {opt bsp}.
They stand for asymptotic standard errors, standard errors from a residual bootstrap, and standard errors from a parametric bootstrap based on draws from the normal distribution, respectively.
Specifying multiple standard error types as in {cmd:setypes(asymp bsp)} is allowed.
The default are asymptotic standard errors.

{phang}
{opt l:evel(#)} specifies the confidence level, as a percentage, for confidence intervals, when they are reported.
The default is {cmd:level(95)} or as set by {helpb set level}.

{phang}
{opt st:ep(steplist)} forecast horizons to be displayed.
{it:steplist} is a Stata {help numlist} and hence does not have to specify sequential numbers.
For example, you can specify {cmd:steplist(1/3 12 24)}.
If {opt step()} is not specified, each table is constructed using all steps available, up to the maximum step available for the {it:stats} for {it:rgmlist}.

{dlgtab:Table Format}

{phang}
{opt byo:rder(irorder)} specifies whether to break down the output table display by combinations of {it:impvar} and {it:respvar}.
By default, the names of impulse and response variables are included in the output table as string variables.
If option {opt byorder()} is used, the impulse and/or response variables are removed from the table and the table is split in several tables, by {it:irorder}.
{opt byorder()} may contain tokens {opt i:mpulse} and/or {opt r:esponse}.
Combinations allowed are {cmd:byorder(i)}, {cmd:byorder(r)}, {cmd:byorder(i r)}, and {cmd:byorder(r i)}.

{phang}
{opt f:ormat(%fmt)} displays the numbers in the output table according to {it:%fmt}, where format is any numeric format allowed by {help format}.
You can only set one {it:%fmt} for all {it:stats}-related numbers displayed.
If you use option {opt keep}, all results variables remain formatted.

{marker list_options}{...}
{phang}
{it:list_options}: all options allowed by {help list}.
These options let you format the output table in many ways.
{cmd:dsimih table}, by default, uses certain {it:list_options}.
Once you use {it:list_options}, the default {it:list_options} are no longer applied.
Default {it:list_options} depend on option {opt byorder()}.
They are as follows:

{p2colset 9 36 36 0}{...}
{p2col:{cmd:byorder} not used}noobs sepby(impulse response){p_end}
{p2col:{cmd:byorder(impulse)}}noobs sepby(response){p_end}
{p2col:{cmd:byorder(response)}}noobs sepby(impulse){p_end}
{p2col:{cmd:byorder(impulse response)}}noobs separator(0){p_end}
{p2col:{cmd:byorder(response impulse)}}noobs separator(0){p_end}
{p2colreset}{...}

{dlgtab:Data Set}

{phang}
{opt k:eep} keeps the data set underlying the table display in memory and does not restore the memory state that was in place before {cmd:dsimih table} was invoked.
{cmd:dsimih table} uses {help dsimih use} to load a data set with dynamic simulation results into memory and then displays it using {cmd:list}.
The data set that option {opt keep} keeps in memory corresponds exactly to the output table displayed by {cmd:dsimih table}.

{pmore}
This option is useful if you want to format the table in a way that {cmd:dsimih table} does not support.
Option {opt keep} gives you the data set underlying the table output of {cmd:dsimih table}.
You can then apply your own tabulation commands to the data.{p_end}

{phang}
{opt clear} specifies that it is okay to replace the data in memory even though the current data have not been saved to disk.
This option is for usage in conjunction with option {opt keep}.


{marker remarks}{...}
{title:Remarks}

{pstd}
{cmd:dsimih table} by default accesses DS results in {cmd:e()} but is also capable of accessing DS results stored in files using its {opt using} modifier.
For details on how the {opt using} modifier works in all {cmd:dsimih} subcommands, see {help dsimih_etodta##theusingmodifier:dsimih etodta}.


{marker examples}{...}
{title:Examples}

{pstd}
Excecuting the following statements will change current {cmd:e()}-results.

{pstd}
Bootstrap replication numbers are set to values that are inappropriate for analysis but appropriate for quick execution of example statements.

{pstd}
Generate example estimates (see {help svarih examples}):

{phang2}{stata webuse lutkepohl2:. webuse lutkepohl2}{p_end}
{phang2}{stata svarih examples bfa_unconstr , ereplace:. svarih examples bfa_unconstr , ereplace}{p_end}
{phang2}{stata dsimih describe , modelstats cmdline:. dsimih describe , modelstats cmdline}{p_end}

{phang2}{stata dsimih create , step(12):. dsimih create , step(12)}{p_end}
{phang2}{stata "version 11.2: set seed 123456":. version 11.2: set seed 123456}{p_end}
{phang2}{stata dsimih create , step(12) bs fromb reps(10):. dsimih create , step(12) bs fromb reps(10)}{p_end}
{phang2}{stata dsimih describe , bootstrap:. dsimih describe , bootstrap}{p_end}

{pstd}
A quick table:

{phang2}{stata dsimih table sfevd , level(90):. dsimih table sfevd , level(90)}{p_end}

{pstd}
A more refined table, using options from {help list}:

{phang2}{stata dsimih tab sf , lev(90) sety(bs) imp(*inc) byorder(r) format(%5.3f) step(0/4 8 12) abb(12) sep(0) noobs:. dsimih tab sf , lev(90) sety(bs) imp(*inc) byorder(r) format(%5.3f) step(0/4 8 12) abb(12) sep(0) noobs}{p_end}

{pstd}
If you need to get your hands on the table data, use option {opt keep}. You can use the prefix {cmd:quietly} if you do not need the data to be displayed.

{phang2}{stata quietly dsimih table sfevd , level(90) setype(bs) impulse(*inc) byorder(r) step(0/4 8 12) keep clear:. quietly dsimih table sfevd , level(90) setype(bs) impulse(*inc) byorder(r) step(0/4 8 12) keep clear}{p_end}
{phang2}{stata describe:. describe}{p_end}


{marker author}{...}
{title:Author}

{phang}
Daniel C. Schneider, Goethe University Frankfurt, dan_schneider@outlook.com


{marker acknowledgements}{...}
{title:Acknowledgements}

{pstd}
{cmd:dsimih table} was inspired in many ways by official Stata's {help irf table}.


{marker alsosee}{...}
{title:Also see}

{psee}
Help:
{helpb irf:[TS] irf},
{helpb dsimih},
{helpb dsimih create},
{helpb dsimih graph},
{helpb dsimih describe},
{helpb dsimih use},
{helpb dsimih drop},
{helpb dsimih etodta}
{p_end}


